#include "global.h"

/*
 * DERIVE_NAME
 *
 * Create a pathname for a file with a specific extension.
 */
char *
derive_name(name, ext)
    char *name, *ext;
{
    register char *cptr;
    unsigned len;

 /* start searching for the .ext after the last path-seperator */
    cptr = rindex(name, PATHSEP);
    if (!cptr)
        cptr = name;

 /* look for the last '.', in case they're are dots in the filename */
    cptr = rindex(cptr, '.');
    if (cptr)
        len = (unsigned) (cptr - name);
    else
        len = strlen(name);

 /* copy everything over, except the old extension, and append the new
    extension */
    cptr = mem_alloc(len + strlen(ext) + 1);
    if (cptr) {
        strncpy(cptr, name, len);
        strcat(cptr, ext);
    }
    return cptr;
}
