#include "global.h"
#include "syms.h"

/*
 * CVT_SYM
 *
 * Replace all symbols in a null-terminated string with their ASCII
 * equivalent.
 */
char *
cvt_sym(string)
    u_char *string;
{
    return cvt_syml(string, ustrlen(string));
}

/*
 * CVT_SYML
 *
 * Replace all symbols in a fixed-length string with their ASCII equivalent.
 */
char *
cvt_syml(string, len)
    u_char *string;
    int len;
{
    int i, c;
    char *cptr;

    cptr = cvtbuf;

    for (i = 0; i < len; i++, string++) {
        c = *string & 0xff;
        if (c == 0x7f) {
            strcpy(cptr, with_idea);
            cptr += strlen(with_idea);
        } else if (c & 0x80) {
            c &= 0x7f;
            strcpy(cptr, sym[c]);
            cptr += strlen(sym[c]);
        } else {
            *cptr++ = c;
        }
    }
    *cptr = '\0';

    return cvtbuf;
}
