#include "global.h"

/*
 * CREATE_DATABASE
 *
 * Create a new database
 */
Database
create_database(name)
    char *name;
{
    Database db;
    char *filename;

    db = (Database) mem_alloc(sizeof(struct database));
    if (!db)
        return NULL;

 /* open the games file (.CBF) */
    filename = derive_name(name, ".cbf");
    if (!filename)
        goto failed;
    db->cbf = file_open(filename, "w+b");
    free(filename);
    if (!db->cbf)
        goto failed;

 /* open the index file (.CBI) */
    filename = derive_name(name, ".cbi");
    if (!filename)
        goto failed;
    db->cbi = file_open(filename, "w+b");
    free(filename);
    if (!db->cbi)
        goto failed;

    db->ngames = 0L;
    write_ngames(db);
    write_index(db, 1L, 0L);

    return db;

failed:
    close_database(db);
    return NULL;
}
