#include "global.h"

/*
 * COPY_DATABASE
 *
 * Make a copy of an existing database.
 */
Database
copy_database(db, name)
    Database db;
    char *name;
{
    Database new_db;

    new_db = create_database(name);
    if (!new_db)
        return NULL;

    if (file_copy(db->cbf, new_db->cbf) < 0) {
        delete_database(new_db);
        return NULL;
    }
    if (file_copy(db->cbi, new_db->cbi) < 0) {
        delete_database(new_db);
        return NULL;
    }
    return new_db;
}
