#include "global.h"

/*
 * CMP_GAME
 *
 * Compare a game according to the criteria supplied.
 */
int
cmp_game(game1, game2, order)
    register GameSort game1, game2;
    Order order[];
{
    char *player1, *player2;
    int orderi;
    int res, len;

    if (!game1 || !game2) {
        error("compare argument is NULL!");
        return 0;
    }
 /* do until no more order criteria in list */
    for (orderi = 0; order[orderi] != NOORDER && orderi < MAX_ORDER;
      orderi++) {
        res = 0;
        switch (order[orderi]) {
        case W_PLAYER:
            len = min(game1->wplayer_len, game2->wplayer_len);
            res = strncmp((char *) game1->pinfo,
              (char *) game2->pinfo, len);
            break;
        case B_PLAYER:
            player1 = (char *) game1->pinfo + game1->bplayer_off;
            player2 = (char *) game2->pinfo + game2->bplayer_off;
            if (game1->bplayer_off) {
                if (game2->bplayer_off)
                    res = strcmp(player1, player2);
                else
                    res = -1;
            } else if (game2->bplayer_off) {
                res = 1;
            } else {
                res = 0;
            }
            break;
        case SOURCE:
            res = strcmp((char *) game1->sinfo,
              (char *) game2->sinfo);
            break;
        case YEAR:
            res = game1->year - game2->year;
            break;
        case ECO:
            res = game1->eco - game2->eco;
            break;
        case NMOVES:
            res = game1->nmoves - game2->nmoves;
            break;
        case ROUND:
            res = game1->round[0] - game2->round[0];
            if (!res) {
                res = game1->round[1] - game2->round[1];
                if (!res) {
                    res = game1->round[2] - game2->round[2];
                }
            }
            break;
        case NOORDER:
        default:
            break;
        }
        if (res) {
            return res;
        }
    }
    return 0;                          /* all fields identical */
}
