%{
/***************************************************************************
 * KSCAN.L -- Scanner for .ks files.
 *
 * Copyright (c)1993 Andy Duplain.
 *
 * Version	Date		Comments
 * =======	====		========
 * 1.0		15/11/93	Initial.
 * 1.1		25/01/94	Changed to C-language comments.
 *		28/01/94	Added wsq, bsq, and pawn-test keywords.
 *				Changed ks, qs, ws and bs keywords to xxd.
 ***************************************************************************/

#include "global.h"
#include "kcompile.h"
#include "kparse.h"

extern int quiet;		/* in cbkey.c */
int linenum;
u_char krelop;			/* relational operator (RELOP_xxx) */
u_char kcolour;			/* colour */
u_char kresult;			/* result */
short kval;			/* value */
short keco;			/* ecocode */
static expect_value = 0;
static void eat_comment P__((void));
static void process_line P__((int echo));
static void get_kval P__((int quiet));

%}

%%
"/*"			{ eat_comment(); }
echo[ \t]*		{
			if (quiet)
				process_line(0);
			else
				process_line(1);
			}
info_tests_only		return INFO_TESTS_ONLY;
subkey_related		return SUBKEY_RELATED;
key			return KEY_WORD;
player			return PLAYER_WORD;
source			return SOURCE_WORD;
year			return YEAR_WORD;
eco			return ECO_WORD;
result			return RESULT_WORD;
nmoves			return NMOVES_WORD;
ep			return EP_WORD;
true|TRUE		return BOOL_TRUE;
false|FALSE		return BOOL_FALSE;
passP			return PASS_P_WORD;
utdP			return UTD_P_WORD;
isoP			return ISO_P_WORD;
dblP			return DBL_P_WORD;
dblisoP			return DBLISO_P_WORD;
ksd			return KSD_WORD;
qsd			return QSD_WORD;
wsd			return WSD_WORD;
bsd			return BSD_WORD;
wsq			return WSQ_WORD;
bsq			return BSQ_WORD;
(wh|Wh)			{
			kcolour = 0;
			return COLOUR;
			}
(bl|Bl)			{
			kcolour = 1;
			return COLOUR;
			}
[KQNBRP]		return PIECE;
"0-1"			{
			kval = 0;
			return RESULTVAL;
			}
draw			{
			kval = 1;
			return RESULTVAL;
			}
"1-0"			{
			kval = 2;
			return RESULTVAL;
			}
("o-o"|"O-O"|"0-0")	return SHORTCASTLE;
("o-o-o"|"O-O-O"|"0-0-0")	return LONGCASTLE;
[0-9]+"..."		{
			get_kval(1);
			kval = to_halfmove(kval, 1);
			return HMOVENUM;
			}
[0-9]+"."		{
			get_kval(1);
			kval = to_halfmove(kval, 0);
			return HMOVENUM;
			}
[abcdefgh] 		return FILE_LET;
[12345678] 		{
			if (!expect_value)
				return RANK_NUM;
			REJECT;
			}
"<="			{
			krelop = RELOP_LE;
			expect_value = 1;
			return RELATIONAL_OP;
			}
">="			{
			krelop = RELOP_GE;
			expect_value = 1;
			return RELATIONAL_OP;
			}
"<"			{
			krelop = RELOP_LT;
			expect_value = 1;
			return RELATIONAL_OP;
			}
">"			{
			krelop = RELOP_GT;
			expect_value = 1;
			return RELATIONAL_OP;
			}
"=="			{
			krelop = RELOP_EQ;
			expect_value = 1;
			return RELATIONAL_OP;
			}
"!="			{
			krelop = RELOP_NE;
			expect_value = 1;
			return RELATIONAL_OP;
			}
[a-e][0-9][0-9]		{
			keco = (*yytext - 'a') * 100;
			keco += (*(yytext+1) - '0') * 10;
			keco += *(yytext+2) - '0';
			return ECOCODE;
			}
[A-E][0-9][0-9]		{
			keco = (*yytext - 'A') * 100;
			keco += (*(yytext+1) - '0') * 10;
			keco += *(yytext+2) - '0';
			return ECOCODE;
			}
\"[^\n\"]+\" 		return STRING;
[0-9]+			{
			expect_value = 0;
			get_kval(0);
			return VALUE;
			}
\n			linenum++;
[ \t]+			;
.			return *yytext;

%%

/*
 * read input until end-of-file or C-language comment terminator is found
 */
static void
eat_comment()
{
	int asterisk, c;

	asterisk = 0;
	while (c = input()) {
		if (c == '/' && asterisk)
			return;

		if (c == '*') {
			asterisk = 1;
		} else {
			asterisk = 0;
			if (c == '\n')
				linenum++;
		}
	}
}

/*
 * read input until end-of-line, and either echo it or throw it away.
 */
static void
process_line(echo)
	int echo;
{
	int c;

	while ((c = input()) != '\n') {
		if (c == 0)
			return;
		else if (echo)
			putchar(c);
	}
	if (echo)
		putchar(c);

	linenum++;
}

/*
 * convert a decimal value string to binary, calling yyerror if an error occurs.
 */
static void
get_kval(quiet)
	int quiet;
{
	register char *cptr = yytext;

	kval = 0;
	while (*cptr) {
		if (*cptr < '0' || *cptr > '9') {
			if (!quiet)
				yyerror("invalid decimal value");
			return;
		}
		kval *= 10;
		kval += *cptr++ - '0';
	}
}
