#ifndef __KCOMPILE_H__
#define __KCOMPILE_H__

#define CONN_BIT        0x80           /* bit-7 signifies a connector */

/*
 * types of test
 */
#define TEST_NONE       0

#define TEST_BOARD      1
#define TEST_MATERIAL   2
#define TEST_MOVEMENT   3
#define TEST_CAPTURE    4
#define TEST_HMOVENUM   5
#define TEST_PLAYER     6
#define TEST_SOURCE     7
#define TEST_YEAR       8
#define TEST_ECO        9
#define TEST_RESULT     10
#define TEST_NMOVES     11
#define TEST_PASS_P     12
#define TEST_UTD_P      13
#define TEST_DBL_P      14
#define TEST_ISO_P      15
#define TEST_DBLISO_P   16
#define TEST_MAX        16

/*
 * types of connector
 */

#define CONN_NONE       (0 | CONN_BIT)

#define CONN_AND        (1 | CONN_BIT)
#define CONN_OR         (2 | CONN_BIT)
#define CONN_THEN       (3 | CONN_BIT)
#define CONN_LATER      (4 | CONN_BIT)

#define CONN_MAX        (4 | CONN_BIT)

/*
 * relational operators used in material test
 */
#define RELOP_NONE      0
#define RELOP_LT        1
#define RELOP_GT        2
#define RELOP_LE        3
#define RELOP_GE        4
#define RELOP_EQ        5
#define RELOP_NE        6

/*
 * misc defines.
 */
#define UNSPEC          0xff
#define is_conn(x)      ((x) & CONN_BIT)
#define is_test(x)      (!is_conn(x))

/*
 * structure to represent material/movement/capture tests
 *
 * Unspecified values for colour, piece, file or rank are set to "UNSPEC".
 */
struct ptest {
    short val;                         /* material only */
    u_short flags;                     /* enpassant, promotion, castle, etc */
    u_char piece;
    u_char piece_taken;                /* capture only */
    u_char colour;
    u_char relop;                      /* material only (RELOP_xxx) */
    u_char file_from, rank_from;
    u_char file_to, rank_to;
};

typedef struct ptest *PTest;

/*
 * structure to store a test
 */
struct kstest {
    struct kstest *left;               /* child (for connector) */
    struct kstest *right;              /* ditto */
    int type;                          /* test (bit-7=0) or connector
                                          (bit-7=1) */
    int negative;                      /* a negative test */
    PTR ptr;                           /* a pointer to test data */
};

typedef struct kstest *KStest;
#define NOTEST ((KStest)-1)

/*
 * structure to store key details
 */
struct key {
    u_long block;                      /* key block number */
    u_long iblock;                     /* last index block number in chain */
    struct key *siblist;               /* list of siblings */
    struct key *childlist;             /* list of children */
    struct kstest *tests;              /* tests */
    u_char *name;                      /* name */
};

typedef struct key *Key;

/*
 * variables
 */
extern Key rootkey;
extern int info_tests_only;
extern int subkey_related;
extern int remove_empty_keys;
extern int compress_keyfile;

/*
 * functions
 */

extern void yyerror P__((char *s));    /* in kparse.y */

extern Key add_key P__((char *name, KStest tests, Key childlist));
extern Key add_sibling_key P__((Key old, Key new));
extern KStest add_test P__((int test, PTR ptr));
extern KStest add_conn P__((int conn, KStest left, KStest right));
extern void free_test P__((KStest test));
extern void init_ptest P__((PTest ptest));
#ifdef DEBUG
extern void dump_key P__((Key key, int level));
extern void dump_test P__((KStest test));
extern void dump_ptest P__((PTest ptest));
#endif

#endif                                 /* __KCOMPILE_H__ */
