/***************************************************************************
 * FBKDUMP -- Dump the contents of an .FBK file
 *
 * Copyright (c)1994 Andy Duplain.
 *
 * Version      Date            Comments
 * =======      ====            ========
 * 1.0          22/08/94        Initial.
 ***************************************************************************/

#include "global.h"

#define BANNER "FBKDUMP  Copyright (c)1993-94 Andy Duplain  "
#ifdef ANSI_C
#define VERSION() output("V1.0 [%s %s]\n", __DATE__, __TIME__);
#else
#define VERSION() output("V1.0\n");
#endif

#define BADMOVE		0x80
#define INTMOVE		0x40
#define DUBMOVE		0xc0

int
main(argc, argv)
	int argc;
	char **argv;
{
	int ncols, bracket_lev, changed;
	char *name, *eval;
	FILE *file;
	u_char data[2];

	output(BANNER);
	VERSION();

	argc--;
	argv++;


	while (argc--) {
		name = *argv++;
		file = fopen(name, "rb");

		puts(name);
		ncols = 0;
		bracket_lev = 0;

		if (!file) {
			fprintf(stderr, "error opening \"%s\"\n", name);
			continue;
		}

		while (fread((char *)data, 1, 2, file) == 2) {
			if (ncols > 70) {
				putchar('\n');
				ncols = 0;
			}

			switch (data[1] & 0xc0) {
			case BADMOVE:
				eval = "?";
				break;
			case INTMOVE:
				eval = "!?";
				break;
			case DUBMOVE:
				eval = "?!";
				break;
			default:
				eval = "";
				break;
			}
			ncols += printf("%s%c%c%c%c%s%s ", data[0] & 0x40 ? "" : "(",
			    (data[0] & 7) + 'a', ((data[0] >> 3) & 7) + '1',
				(data[1] & 7) + 'a', ((data[1] >> 3) & 7) + '1',
				eval, data[0] & 0x80 ? ")" : "");

			changed = 0;
			if (!(data[0] & 0x40)) {
				bracket_lev++;
				changed++;
			}
			if (data[0] & 0x80) {
				bracket_lev--;
				changed++;
			}
			if (changed && bracket_lev == 0) {
				puts("\n-----------------------------------------");
				ncols = 0;
			}
		}
		fclose(file);
	}
	return 0;
}
