/***************************************************************************
 * CBDUMP -- Dump the contents of a ChessBase file.
 *
 * Copyright (c)1993 Andy Duplain.
 *
 * Version      Date            Comments
 * =======      ====            ========
 * 1.0          19/01/94        Initial.
 ***************************************************************************/

#include "global.h"

#define BANNER "CBDUMP  Copyright (c)1993-94 Andy Duplain  "
#ifdef ANSI_C
#define VERSION() output("V1.0 [%s %s]\n", __DATE__, __TIME__);
#else
#define VERSION() output("V1.0\n");
#endif

static void usage P__((void));

static int quiet = 0;                  /* -q flag */
static char *dbname;
static u_long first = 1L, last = 0xffffffffL;
static Database db = NULL;
static Game game = NULL;

static void
usage()
{
    error("usage: cbdump [options] database");
    error("options:");
    error("  -q\t\tquiet");
    error("  -r x-y\tspecify the first and last game to list");
    exit(1);
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    int c, j, col;
    u_long i;
    u_char *uptr;

    opterr = 0;
    while ((c = getopt(argc, argv, "qr:")) != EOF) {
        switch (c) {
        case 'q':
            quiet++;
            break;
        case 'r':
            first = range_first(optarg);
            last = range_last(optarg);
            if ((!first || !last) || first > last) {
                error("invalid range");
                return 1;
            }
            break;
        case '?':
        default:
            usage();
        }
    }
    argc -= optind;
    argv += optind;

    if (argc != 1)
        usage();

    dbname = *argv;
    kill_ext(dbname);

    if (!quiet) {
        output(BANNER);
        VERSION();
    }
    db = open_database(dbname);
    if (!db)
        return 1;

    if (last > db->ngames)
        last = db->ngames;
    if (first > last)
        first = last;

    game = (Game) mem_alloc(sizeof(struct game));
    if (!game)
        return 1;

    for (i = first; i <= last; i++) {
        game_tidy(game);
        game->num = i;
        if (read_game(db, game) < 0)
            continue;
        printf("game %lu (offset %lu)\n", i, read_index(db, i));

        printf("plen=%d slen=%d mlen=%d clen=%d year=%d\n",
          game->plen, game->slen, game->mlen, game->clen,
          game->year);
        printf("w_elo=%d b_elo=%d nmoves=%d halfmove=%d ep=%d\n",
          game->w_elo, game->b_elo, game->nmoves,
          game->halfmove, game->ep);
        printf("eco_letter=%d eco_main=%d eco_sub=%d\n",
          game->eco_letter, game->eco_main, game->eco_sub);

    /* dump header */
        j = 14;
        uptr = game->header;
        puts("header");
        while (j--) {
            printf("%02x ", *uptr);
            uptr++;
        }
        putchar('\n');

    /* dump moves */
        col = 0;
        j = game->mlen;
        uptr = game->moves;
        puts("moves");
        while (j--) {
            col += printf("%02x ", *uptr);
            uptr++;
            if (col >= 77) {
                putchar('\n');
                col = 0;
            }
        }
        putchar('\n');

    /* dump comments */
        col = 0;
        j = game->clen;
        uptr = game->comments;
        puts("comments");
        while (j--) {
            if (*uptr & 0x80 || *uptr < ' ') {
                col += printf("<%02x>", *uptr);
            } else {
                putchar(*uptr);
                col++;
            }
            uptr++;
            if (col >= 77) {
                putchar('\n');
                col = 0;
            }
        }
        putchar('\n');
        putchar('\n');
    }

    if (game)
        game_free(game);
    close_database(db);

    return 0;
}
