#ifndef __CBASCII_H__
#define __CBASCII_H__

/* "header" and "preset" defines */
#define TYPE_CB         1              /* ChessBase */
#define TYPE_PGN        2              /* Portable Game Notation (PGN) */

#define DIAG_CB         1               /* ChessBase diagram */
#define DIAG_8X8        2               /* 8x8 diagram */

extern int conv;                       /* conversion */
extern int comm_strip;                 /* strip comments */
extern int var_strip;                  /* strip variations */
extern int format;                     /* import / export format */
extern int diagtype;                   /* diagram type */
extern char nat_black_sq;              /* "Natural" diagram black-square type */
extern int append;                     /* -a flag */
extern int quiet;                      /* -q flag */
extern int testmode;                   /* -t flag */
extern int ignore_errors;              /* -I flag */
extern int dont_enforce;               /* -E flag */
extern u_long skiplines;             /* -L flag */
extern int long_comments;              /* -l flag */
extern int no_nag;                     /* PGN without NAGs */
extern u_long first, last;
extern char *dbname;
extern char *asciiname;
extern Database db;
extern FILE *file;
extern char comm_start;                /* comment start character */
extern char comm_end;                  /* comment end character */
extern char var_start;                 /* variation start character */
extern char var_end;                   /* variation end character */
extern char *ourpath;                  /* path to this utility */

/* Diagram characters */
extern u_char diag_top_left_corner;
extern u_char diag_top_right_corner;
extern u_char diag_bottom_left_corner;
extern u_char diag_bottom_right_corner;
extern u_char diag_top_border;
extern u_char diag_left_border;
extern u_char diag_right_border;
extern u_char diag_bottom_border;
extern u_char diag_white_square;
extern u_char diag_black_square;
extern u_char __far diag_white_pieces[];
extern u_char __far diag_black_pieces[];
extern u_char diag_space_between_squares;
extern u_char diag_borders;

#endif                                 /* __CBASCII_H__ */
