%e 4096
%{
/***************************************************************************
 * ASCAN.L -- Scanner for PGN game files.
 *
 * Copyright (C)1993 Andy Duplain.
 *
 * Version  Date        Comments
 * =======  ====        ========
 * 1.2      22/08/95    Added PlyCount and LongECO tag-pairs
 * 1.1      02/02/94    Added supplemental tag-pairs from PGN spec.
 *                      1993-01-30.
 * 1.0      21/12/93    Initial.
 ***************************************************************************/

#include "global.h"
#include "ascan.h"

int yywrap() {
	return 1;
}

u_long linenum;

static void count_newlines P__((void));
static void eat_line P__((void));

/* Microsoft C ANSI environment... */
#if _MSC_VER > 600
#include <io.h>
#include <errno.h>
#define read _read
#define fileno _fileno
#define isatty _isatty
#endif

%}

spc     ([ \t]+)
piece   [KQBNRP]
prom    "="?[KQBNRP]
file    [a-h]
rank    [1-8]
value   [0-9]+
x       [xX]

%%

^"[Event "[^\n]*"]".*$              return A_PGN_EVENT;
^"[Site "[^\n]*"]".*$               return A_PGN_SITE;
^"[Date "[^\n]*"]".*$               return A_PGN_DATE;
^"[Round "[^\n]*"]".*$              return A_PGN_ROUND;
^"[White "[^\n]*"]".*$              return A_PGN_WHITE;
^"[Black "[^\n]*"]".*$              return A_PGN_BLACK;
^"[Result "[^\n]*"]".*$             return A_PGN_RESULT;
^"[WhiteTitle "[^\n]*"]".*$         return A_PGN_WHITETITLE;
^"[BlackTitle "[^\n]*"]".*$         return A_PGN_BLACKTITLE;
^"[WhiteElo "[^\n]*"]".*$           return A_PGN_WHITEELO;
^"[BlackElo "[^\n]*"]".*$           return A_PGN_BLACKELO;
^"[WhiteUSCF "[^\n]*"]".*$          return A_PGN_WHITEUSCF;
^"[BlackUSCF "[^\n]*"]".*$          return A_PGN_BLACKUSCF;
^"[WhiteNA "[^\n]*"]".*$            return A_PGN_WHITENA;
^"[BlackNA "[^\n]*"]".*$            return A_PGN_BLACKNA;
^"[WhiteType "[^\n]*"]".*$          return A_PGN_WHITETYPE;
^"[BlackType "[^\n]*"]".*$          return A_PGN_BLACKTYPE;
^"[EventDate "[^\n]*"]".*$          return A_PGN_EVENTDATE;
^"[EventSponsor "[^\n]*"]".*$       return A_PGN_EVENTSPONSOR;
^"[Section "[^\n]*"]".*$            return A_PGN_SECTION;
^"[Stage "[^\n]*"]".*$              return A_PGN_STAGE;
^"[Board "[^\n]*"]".*$              return A_PGN_BOARD;
^"[Opening "[^\n]*"]".*$            return A_PGN_OPENING;
^"[Variation "[^\n]*"]".*$          return A_PGN_VARIATION;
^"[SubVariation "[^\n]*"]".*$       return A_PGN_SUBVARIATION;
^"[ECO "[^\n]*"]".*$                return A_PGN_ECO;
^"[NIC "[^\n]*"]".*$                return A_PGN_NIC;
^"[Time "[^\n]*"]".*$               return A_PGN_TIME;
^"[UTCTime "[^\n]*"]".*$            return A_PGN_UTCTIME;
^"[UTCDate "[^\n]*"]".*$            return A_PGN_UTCDATE;
^"[TimeControl "[^\n]*"]".*$        return A_PGN_TIMECONTROL;
^"[SetUp "[^\n]*"]".*$              return A_PGN_SETUP;
^"[FEN "[^\n]*"]".*$                return A_PGN_FEN;
^"[Termination "[^\n]*"]".*$        return A_PGN_TERMINATION;
^"[Annotator "[^\n]*"]".*$          return A_PGN_ANNOTATOR;
^"[Mode "[^\n]*"]".*$               return A_PGN_MODE;
^"[PlyCount "[^\n]*"]".*$           return A_PGN_PLYCOUNT;
^"[LongECO "[^\n]*"]".*$            return A_PGN_LONGECO;

{value}{spc}?"."?                   return A_WHITE_MOVENUM;
{value}{spc}?"."{spc}?".."+         return A_BLACK_MOVENUM;

{file}{rank}                        return A_PAWN_MOVE;
{file}{rank}{prom}                  return A_PAWN_MOVE_P;
{file}{x}{file}{rank}               return A_PAWN_CAPTURE;
{file}{file}{rank}                  return A_PAWN_CAPTURE;
{file}{x}{file}                     return A_PAWN_CAPTURE_SHORT;
{file}{file}                        return A_PAWN_CAPTURE_SHORT;
{file}{x}{file}{rank}{prom}         return A_PAWN_CAPTURE_P;
{file}{file}{rank}{prom}            return A_PAWN_CAPTURE_P;
{file}{x}{file}{prom}               return A_PAWN_CAPTURE_SHORT_P;
{file}{file}{prom}                  return A_PAWN_CAPTURE_SHORT_P;
{piece}{file}{rank}                 return A_PIECE_MOVE;
{piece}{file}{file}{rank}           return A_PIECE_MOVE_F;
{piece}{rank}{file}{rank}           return A_PIECE_MOVE_R;
{piece}{file}{rank}{file}{rank}     return A_PIECE_MOVE_FR;
{piece}{x}{file}{rank}              return A_PIECE_CAPTURE;
{piece}{file}{x}{file}{rank}        return A_PIECE_CAPTURE_F;
{piece}{rank}{x}{file}{rank}        return A_PIECE_CAPTURE_R;
{piece}{file}{rank}{x}{file}{rank}  return A_PIECE_CAPTURE_FR;
("O-O"|"o-o"|"0-0")                 return A_SHORT_CASTLE;
("O-O-O"|"o-o-o"|"0-0-0")           return A_LONG_CASTLE;

"+"                                 return A_CHECK;
"#"                                 return A_MATE;
"!"                                 return A_GOOD_MOVE;
"?"                                 return A_BAD_MOVE;
"!?"                                return A_INTERESTING_MOVE;
"?!"                                return A_DUBIOUS_MOVE;
"!!"                                return A_BRILLIANT_MOVE;
"??"                                return A_BLUNDER_MOVE;
"$"[0-9]+                           return A_NAG;
"$#"                                return A_NAG_MATE;
"$N"                                return A_NAG_NOVELTY;

("1-0"|"1:0")                       return A_WHITE_WINS;
("0-1"|"0:1")                       return A_BLACK_WINS;
("1/2-1/2"|"1/2:1/2"|"1/2"|"draw")  return A_DRAW;
"*"                                 return A_UNFINISHED;

"{"[^}]*"}"                         {
    count_newlines();
    return A_COMMENT;
                                    }
"("                                 return A_VARSTART;
")"                                 return A_VAREND;
";"                                 eat_line();
^"%"                                eat_line();
\n                                  linenum++;
[ \t]+                              ;
.                                   return *yytext;

%%

/*
 * COUNT_NEWLINES
 *
 * Count the number of newlines in "yytext", and change them to spaces.
 * Change all '{' and '}' characters to spaces.
 */
static void
count_newlines()
{
    register char *s;

    s = yytext;
    while(*s) {
        if (*s == '\n') {
            linenum++;
            *s = ' ';
        }
        if (*s == '{' || *s == '}')
            *s = ' ';
        s++;
    }
}

/*
 * EAT_LINE
 *
 * Read from input until a newline or nul is found.
 */
static void
eat_line()
{
    int c;

    while (c = input()) {
        if (c == '\n') {
            linenum++;
            return;
        }
    }
}
