/*
	Filename:	iff.h
	Date:			20.96.11.25

	Electronic Arts IFF File Format Header
*/
#ifndef IFF_H
#define IFF_H

#ifndef TYPES_H
#include <types.h>
#endif	/* TYPES_H */
#ifndef __STDIO_H
#include <stdio.h>
#endif	/* __STDIO_H */

/* Error Definitions - Form specific definitions occur in related headers */
#define IFFERROR_NONE			0
#define IFFERROR_MEMORY			1
#define IFFERROR_OPEN			2
#define IFFERROR_SEEK         3
#define IFFERROR_READ         4
#define IFFERROR_WRITE        5
#define IFFERROR_FORMAT       6
#define IFFERROR_NESTED		   7
#define IFFERROR_FORM			8
#define IFFERROR_COMPRESSION  9

/* ID Size */
#define IDSIZE						(sizeof(long))

/* Four-character ID maker. */
#define MakeID(a,b,c,d)			((long)(a) << 24L | (long)(b) << 16L | (c) << 8 | (d))

/* Standard Reserved Group ID's */
/* A Chunk of ID contains a SubTypeID followed by zero or more chunks.*/
#define ID_FORM               MakeID('F','O','R','M')
#define ID_PROP               MakeID('P','R','O','P')
#define ID_LIST               MakeID('L','I','S','T')
#define ID_CAT                MakeID('C','A','T',' ')
#define ID_FILLER             MakeID(' ',' ',' ',' ')
/* Generic Chunk ID's we may encounter */
#define ID_ANNO					MakeID('A','N','N','O')
#define ID_AUTH					MakeID('A','U','T','H')
#define ID_CHRS					MakeID('C','H','R','S')
#define ID_Copyright				MakeID('(','c',')',' ')
#define ID_CSET					MakeID('C','S','E','T')
#define ID_FVER					MakeID('F','V','E','R')
#define ID_NAME					MakeID('N','A','M','E')
#define ID_TEXT					MakeID('T','E','X','T')
#define ID_BODY					MakeID('B','O','D','Y')

/* IFF ChuckHeader Structure Definition */
struct IFF_ChunkHeader
{
   long   ID;                       /* IFF 4-Byte IDentification           	*/
   long   Size;                     /* Size of Chunk (not including ID&Size) 	*/
};

/* Incorporates Pad Byte (if needed) and Chunk Header Size */
#define AlignedSize(s)			((long)(s + (s & 1) + sizeof(struct IFF_ChunkHeader)))

/* IFF Chunk Structure Definition */
struct IFF_Chunk
{
	long ID;									/* IFF 4-Byte IDentification           */
	long Size;								/* Size of IFF Chunk                   */
	uchar *Data;							/* Pointer to Chunk Data in Memory     */
	struct IFF_Chunk *Prev;				/* Doubly-Linked List of Chunks			*/
	struct IFF_Chunk *Next;				/* ...									      */
};

/*
	NOTE: structure casting can be applied to IFF_Chunk.Data as if it were a
	pointer to that structure in order to access its elements!
*/

/* IFF Chunk List (Generic Pointer Construct) */
struct IFF_ChunkList
{
	struct IFF_Chunk *First;			/* Pointer to First Chunk 					*/
   struct IFF_Chunk *Last;				/* Pointer to Last Chunk					*/
};

#ifndef IFF_C
extern int IFF_Error;

/* External Function References */
extern void *IFF_Malloc(int size);
extern void far *IFF_Farmalloc(ulong size);
extern struct IFF_Chunk *IFF_InsertChunk(struct IFF_ChunkList *CL,struct IFF_Chunk *Prev);
extern void IFF_DeleteChunk(struct IFF_ChunkList *CL,struct IFF_Chunk *C);
extern int IFF_Seek(FILE *fp,long nbytes,int offset);
extern int IFF_Read(FILE *fp,uchar *buf,long nbytes);
extern int IFF_Write(FILE *fp,uchar *buf,long nbytes);
extern int IFF_ReadChunkHeader(FILE *fp,struct IFF_ChunkHeader *CkHdr);
extern int IFF_WriteChunkHeader(FILE *fp,struct IFF_ChunkHeader *CkHdr);
extern int IFF_ReadChunk(FILE *fp,struct IFF_Chunk *Chk);
extern int IFF_WriteChunk(FILE *fp,struct IFF_Chunk *Chk);
extern int IFF_ReadFile(string filename,long ID,struct IFF_ChunkList *CL);
extern int IFF_WriteFile(string filename,long ID,struct IFF_ChunkList *CL);
extern int IFF_VerifyFormat(FILE *fp,long ID);
#endif	/* IFF_C */

#endif	/* IFF_H */

