/*
	Filename:	8svx.h
	Date:			20.96.11.25

	Electronic Arts IFF 8SVX File Format Header
*/
#ifndef SVX8_H
#define SVX8_H

#ifndef TYPES_H
#include <types.h>
#endif	/* TYPES_H */
#ifndef __STDIO_H
#include <stdio.h>
#endif	/* __STDIO_H */

/* Error Definitions */
#define IFFERROR_NOVHDR			10

/* Standard 8SVX Group ID's */
#define ID_8SVX					MakeID('8','S','V','X')
#define ID_VHDR					MakeID('V','H','D','R')
#define ID_ATAK					MakeID('A','T','A','K')
#define ID_RLSE					MakeID('R','L','S','E')
#define ID_CHAN					MakeID('C','H','A','N')

/* A fixed-point value, 16 bits to the left of the point and 16 to the right.
	A Fixed is a number of 2**16ths, i.e. 65536ths. */
/* Unity = Fixed 1.0 = maximum volume */
#define Unity 						0x10000L

/* SVX8_8svx.Chan  Specifications*/
#define LEFT						2L
#define RIGHT						4L
#define STEREO						6L

/* 8SVX Voice8Header Structure Definition */
struct SVX8_Vhdr
{
	ulong Oneshothi;						/* Num Samples in high octave 1-shot part */
   ulong Repeathi;						/* Num Samples in high octave repeat part */
   ulong Samplescycle;					/* Num Samples/cycle in high octave, else 0 */
   uword Samplessec;						/* Samples Per Second - Sampling Rate */
   uchar Octaves;							/* Number of Octaves */
   uchar Compression;					/* Compression algorithm used - see below */
   long Volume;							/* Volume from 0 to Unity - see below */
};

/* SVX8_Vhdr.Compression */
/* Choice of compression algorithm applied to the samples. */
#define SVX8_CmpNone				0		/* Not compressed */
#define SVX8_CmpFibDelta		1		/* Fibonacci-delta encoding (Appendix C) */

/* 8SVX Envelope Structure Definition (Used for ATAK and RLSE chunks) */
struct SVX8_Env
{
	uword duration;						/* Segment Duration in Milliseconds, > 0 */
   long dest;								/* Destination volume factor */
};

/* 8SVX 8svx Structure Definition */
struct SVX8_8svx
{
   struct IFF_ChunkList CList;		/* Contains Sequentially-Read Chunks 	*/

	/* Chunk Pointers into ChunkList */
	struct IFF_Chunk *Vhdr;          /* Voice8Header								*/
   struct IFF_Chunk **Atak;         /* Attack Envelopes							*/
   struct IFF_Chunk **Rlse;         /* Release Envelopes							*/
   struct IFF_Chunk *Chan;          /* Channel 										*/
   struct IFF_Chunk *Name;          /* Voice Name 									*/
   struct IFF_Chunk *Copyright;     /* Copyright									*/
   struct IFF_Chunk *Author;        /* Author 										*/
   struct IFF_Chunk *Annotations;	/* Annotations									*/
   struct IFF_Chunk *Body;				/* Body											*/
};

#ifndef SVX8_C
/* External Function References */

extern struct SVX8_8svx *SVX8_Read(string filename);
extern int SVX8_Write(string filename,struct SVX8_8svx *svx);
#endif /* SVX8_C */

#endif	/* SVX8_H */

